/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileBorder;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class BlockBorder
extends BlockInterface
implements IPermission {
    public static PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)3);

    public BlockBorder() {
        super(Material.field_151576_e);
        this.setName("npcborder");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(CustomRegisters.tab);
        this.func_149722_s();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
    }

    public TileEntity func_149915_a(@Nonnull World var1, int var2) {
        return new TileBorder();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    private TileBorder getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBorder) {
            return (TileBorder)tile;
        }
        return null;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.SaveTileEntity;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (!world.field_72995_K && currentItem.func_77973_b() == CustomRegisters.wand) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.Border, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase entity, @Nonnull ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_175656_a(pos, state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(l)));
        TileBorder tile = (TileBorder)world.func_175625_s(pos);
        TileBorder adjacent = this.getTile(world, pos.func_177968_d());
        if (adjacent == null) {
            for (int i = 0; i < 26; ++i) {
                switch (i) {
                    case 0: {
                        adjacent = this.getTile(world, pos.func_177968_d());
                        break;
                    }
                    case 1: {
                        adjacent = this.getTile(world, pos.func_177978_c());
                        break;
                    }
                    case 2: {
                        adjacent = this.getTile(world, pos.func_177974_f());
                        break;
                    }
                    case 3: {
                        adjacent = this.getTile(world, pos.func_177976_e());
                        break;
                    }
                    case 4: {
                        adjacent = this.getTile(world, pos.func_177984_a());
                        break;
                    }
                    case 5: {
                        adjacent = this.getTile(world, pos.func_177977_b());
                        break;
                    }
                    case 6: {
                        adjacent = this.getTile(world, pos.func_177968_d().func_177974_f());
                        break;
                    }
                    case 7: {
                        adjacent = this.getTile(world, pos.func_177968_d().func_177976_e());
                        break;
                    }
                    case 8: {
                        adjacent = this.getTile(world, pos.func_177978_c().func_177974_f());
                        break;
                    }
                    case 9: {
                        adjacent = this.getTile(world, pos.func_177978_c().func_177976_e());
                        break;
                    }
                    case 10: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177968_d());
                        break;
                    }
                    case 11: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177978_c());
                        break;
                    }
                    case 12: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177974_f());
                        break;
                    }
                    case 13: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177976_e());
                        break;
                    }
                    case 14: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177968_d().func_177974_f());
                        break;
                    }
                    case 15: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177968_d().func_177976_e());
                        break;
                    }
                    case 16: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177978_c().func_177974_f());
                        break;
                    }
                    case 17: {
                        adjacent = this.getTile(world, pos.func_177977_b().func_177978_c().func_177976_e());
                        break;
                    }
                    case 18: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177968_d());
                        break;
                    }
                    case 19: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177978_c());
                        break;
                    }
                    case 20: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177974_f());
                        break;
                    }
                    case 21: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177976_e());
                        break;
                    }
                    case 22: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177968_d().func_177974_f());
                        break;
                    }
                    case 23: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177968_d().func_177976_e());
                        break;
                    }
                    case 24: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177978_c().func_177974_f());
                        break;
                    }
                    case 25: {
                        adjacent = this.getTile(world, pos.func_177984_a().func_177978_c().func_177976_e());
                    }
                }
                if (adjacent != null) break;
            }
        }
        if (adjacent != null) {
            NBTTagCompound compound = new NBTTagCompound();
            adjacent.writeExtraNBT(compound);
            if (tile != null) {
                tile.readExtraNBT(compound);
            }
        }
        if (tile != null) {
            tile.rotation = l;
        }
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            if (adjacent == null) {
                NoppesUtilServer.sendOpenGui((EntityPlayer)entity, EnumGuiType.Border, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                entity.func_145747_a((ITextComponent)new TextComponentTranslation("barrier.copied.around", new Object[0]));
            }
        }
    }
}

